<?php

//Schreiben Sie die Klasse "Database". Die Klasse Database soll eine Kindklasse der PDO-Klasse sein. 

class database extends PDO implements DatabaseInterface {

    public function delete($table, $where) {
        $sql = "DELETE FROM $table WHERE $where";
        $result = $this->exec($sql);
    }

    public function get($table): array {
        $sql = "SELECT * FROM $table ";
        $result = $this->query($sql);
        return $result->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getWhere($table, $where): array {
        $sql = "SELECT * FROM $table WHERE $where ";
        $result = $this->query($sql);
        return $result->fetchAll(PDO::FETCH_ASSOC);
    }

    public function ownSQL($sql): array {
        $result = $this->query($sql);
        return $result->fetchAll(PDO::FETCH_ASSOC);
    }

    public function insert($table, array $data) {
        $field = [];
        $values = [];

        foreach ($data as $key => $value) {
            $fields[] = $key;
            $prepare[] = "?";
            $values[] = $value;
        }

        $fieldstring = implode(",", $fields);
        $valuestring = implode(",", $prepare);

        $sql = "INSERT INTO $table ($fieldstring) VALUES (" . $valuestring .= ")";

        $stmt = $this->prepare($sql);

        for ($i = 1; $i <= count($values); $i++) {
            $stmt->bindParam($i, $values[$i - 1]);
        }

        $stmt->execute();
    }

    public function update($table, array $data, $where) {
        $sql = "UPDATE $table SET ";
        $array = [];
        $values = [];
        foreach ($data as $key => $value) {
            $array[] = "{$key}=?";
            $values[] = $value;
        }
        $sql .= implode(" , ", $array);
        $sql .= " WHERE $where";

        $stmt = $this->prepare($sql);
        
        $i = 1;
        foreach ($values as &$value) {
            $stmt->bindParam($i, $value);
            $i++;
        }
        $stmt->execute();
    }

    public function __construct(string $dsn, string $username, string $passwd, array $options = NULL) {
        parent::__construct($dsn, $username, $passwd, $options);
    }

}

interface DatabaseInterface {

    /**
     * Trägt einen Datensatz ein
     * @param string $table Tabelle
     * @param array $data Datenarray, die Schlüssel sind die Spaltennamen 
     */
    public function insert($table, array $data); //ein datenzatz assoz Array name/ eine reihe

    /**
     * Löscht einen oder mehrere Datensätze
     * @param string $table Tabelle
     * @param string $where Where-Klausel
     */
    public function delete($table, $where);

    /**
     * Aktualisiert einen Datensatz
     * @param string $table Tabelle
     * @param array $data Datenarray, die Schlüssel sind die Spaltennamen
     * @param string $where Where-Klausel
     */
    public function update($table, array $data, $where);

    /**
     * Liefert alle Datensätze einer Tabelle zurück (Hinweis: Methode fetchAll() nutzen)
     * @param string $table Tabelle
     * @return array Assoziatives Result-Array
     */
    public function get($table);

    /**
     * Liefert bestimmte Datensätze einer Tabelle zurück (Hinweis: Methode fetchAll() nutzen)
     * @param string $table Tabelle
     * @param string $where Where-Klausel
     * @return array Assoziatives Result-Array
     */
    public function getWhere($table, $where);
}
