var pages = new Array();
var acualPage;
var isUnfolded = false;
var isInAnimation = false;

var itemCountPerRow = 3;
var actualItemCountInRow = 0;

var isPageScriptFinished = true;
var pageStep = 1;

async function init() {
    loadPages();
    var bodyArr = document.getElementsByTagName("body");
    var body = bodyArr[0];
    pages.forEach(page => {
        body.append(page.getCollapsedHTML());
    });
    await delay(100);
    await unfold(document.getElementById("Page1"), true);
    document.getElementById("Page1").classList.remove("hidden");
}
function loadPages() {
    var numberOfPages;
    var xhr = new XMLHttpRequest();
    xhr.open('post', "php/getNumberOfPages.php", false);
    xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
    xhr.onreadystatechange = () => {
        if (xhr.readyState == 4 && xhr.status == 200) {
            numberOfPages = xhr.responseText;
        }
    }
    xhr.send();
    for (var i = 0; i < numberOfPages; i++) {
        var page = new Page(i + 1);
        pages.push(page);
    }
}

class Page {
    html;
    css;
    script;
    scriptPath;
    scriptTag;
    cssPath;
    htmlPath;

    domElement;

    title;

    constructor(id) {
        this.pageId = id;
        console.dir("constructor id: " + this.pageId);
        this.getPageInfo();
        if (this.htmlPath !== "empty") {
            this.loadContentFile();
        } else {
            this.html = "";
        }
        if (this.cssPath !== "") {
            this.loadCSS();
        } else {
            this.css = null;
        }
        if (this.scriptPath !== "") {
            this.loadScriptFile();
        } else {
            this.script = null;
        }
    }
    getPageInfo() {
        var postParams = "pageId=" + this.pageId;
        var response;
        var xhr = new XMLHttpRequest();
        xhr.open('post', "php/getPageInfo.php", false);
        xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
        xhr.onreadystatechange = () => {
            if (xhr.readyState == 4 && xhr.status == 200) {
                response = xhr.responseText;
                console.dir("pageInfoResponse:" + response);
            }
        }
        xhr.send(postParams);
        var pageInfo = JSON.parse(response)[0];
        //console.dir("PageInfo: " + pageInfo);
        this.title = pageInfo.title;
        this.htmlPath = pageInfo.content_path;
        this.cssPath = pageInfo.css_path;
        this.scriptPath = pageInfo.script_path;
    }
    loadContentFile() {
        var xhr = new XMLHttpRequest();
        //console.dir(this.htmlPath);
        xhr.open('post', 'pages/' + this.htmlPath, 'false');
        xhr.onreadystatechange = () => {
            if (xhr.readyState == 4 && xhr.status == 200) {
                this.html = xhr.responseText;
            }
        }
        xhr.send();
    }
    loadCSS() {
        this.css = "<link rel='stylesheet' href='css/pages/" + this.cssPath + "' id='style" + this.pageId + "'>";
    }
    loadScriptFile() {
        console.dir("LoadScriptFile for PageID: " + this.pageId);
        var xhr = new XMLHttpRequest();
        xhr.open('post', 'scripts/pages/' + this.scriptPath, false);
        xhr.onreadystatechange = () => {
            if (xhr.readyState == 4 && xhr.status == 200) {
                this.script = xhr.responseText;
                console.dir("Script for PageId " + this.pageId + " loaded");
                this.scriptTag = document.createElement("script");
                this.scriptTag.setAttribute("src", 'scripts/pages/' + this.scriptPath);
                //this.scriptTag.setAttribute("onload", "function(){}");
            }
        }
        xhr.send();
    }
    getCollapsedHTML() {
        var tileWidth = getComputedStyle(document.documentElement, null).getPropertyValue("--tile-width");
        tileWidth = Number(tileWidth.substring(0, tileWidth.indexOf("px")));
        //console.dir("tileWidth: " + tileWidth);
        var rowMargin = getComputedStyle(document.documentElement, null).getPropertyValue("--row-margin");
        rowMargin = Number(rowMargin.substring(0, rowMargin.indexOf("px")));
        //console.dir("Row Margin CSS Property: " + rowMargin);
        var tilePadding = getComputedStyle(document.documentElement, null).getPropertyValue("--tile-padding");
        tilePadding = Number(tilePadding.substring(0, tilePadding.indexOf("px")));
        var margin = (row - 1) * rowMargin * 2;
        var padding = (row - 1) * tilePadding * 2;
        var box = document.createElement('div');
        box.setAttribute("id", "Page" + this.pageId);
        box.setAttribute("pageIndex", this.pageId - 1);
        box.classList.add("hidden");
        actualItemCountInRow++;
        //console.dir("Row calc: " + this.pageId + " / " + itemCountPerRow + " = " + actualItemCountInRow / itemCountPerRow)
        var row = Math.ceil(this.pageId / itemCountPerRow);
        box.setAttribute("row", row);
        var left = ((tileWidth + (rowMargin * 2) + (tilePadding * 2)));
        //console.dir("Calculated left: " + left);
        box.style.left = (left * (actualItemCountInRow - 1)) + "px";
        var top;
        if (row > 1) {
            var tileHeight = getComputedStyle(document.documentElement, null).getPropertyValue("--tile-height");
            tileHeight = Number(tileHeight.substring(0, tileHeight.indexOf("px")));
            //console.dir("Tile Height CSS Property: " + tileHeight);

            //console.dir("row value: " + row);
            var height = (row - 1) * tileHeight;
            var margin = (row - 1) * rowMargin * 2;
            var padding = (row - 1) * tilePadding * 2;
            //console.dir("Calculated Values: Height: " + height + " margin: " + margin + " padding: " + padding);
            top = (height + margin + padding) + "px";
            //console.dir("Tile Top: " + top);
            box.style.top = top;
        }
        document.getElementById("body")
        box.style.setProperty("--collapsed-left", (left * (actualItemCountInRow - 1)) + "px");
        box.style.setProperty("--collapsed-top", top);
        if (actualItemCountInRow >= itemCountPerRow) {
            actualItemCountInRow = 0;
        }
        box.onclick = onClickEventHandler;
        box.classList.add("collapsedPage");
        var title = document.createElement("div");
        title.classList.add("collapsedPageTitle");
        title.innerHTML = this.title;
        this.domElement = box;
        box.append(title);
        return box;
    }
}
async function unfold(thisElement, skipAnimation = false) {
    if (!isUnfolded) {
        isUnfolded = true;
        isInAnimation = true;

        if (!skipAnimation) {
            thisElement.classList.add("unfold");
            await delay(2000);
            thisElement.children[0].classList.add("moveTitleUp");
            await delay(1000);
            thisElement.classList.add("unfolded");
            thisElement.style.left = "";
            thisElement.style.top = "";
            thisElement.classList.remove("unfold");
        } else {
            thisElement.classList.add("unfolded");
        }
        var head = document.getElementsByTagName("head");
        head[0].innerHTML += pages[thisElement.getAttribute("pageIndex")].css;
        console.dir("Add Inner HTML of Page: " + thisElement.id);
        console.dir(pages[thisElement.getAttribute("pageIndex")].html);
        thisElement.innerHTML = pages[thisElement.getAttribute("pageIndex")].html;
        eval?.(pages[thisElement.getAttribute("pageIndex")].script);
        isInAnimation = false;
    }
}
async function fold(thisElement) {
    if (isUnfolded) {
        isInAnimation = true;
        await fadeOut(document.getElementById("start"));
        console.dir(typeof onFold)
        if (typeof onFold === "function") {
            onFold();
        }

        thisElement.innerHTML = "";

        //console.dir("style" + (thisElement.getAttribute("pageIndex") + 1));
        var lastCSSHead = document.getElementById("style" + (Number(thisElement.getAttribute("pageIndex")) + 1));
        var head = document.getElementsByTagName("head");
        //console.dir("CSS Tag to remove: " + lastCSSHead);
        head[0].removeChild(lastCSSHead);
        try {
            head[0].removeChild(pages[thisElement.getAttribute("pageIndex")].scriptTag);
        } catch (ex) {
            console.error("Script-Tag Remove failed");
        }
        var title = document.createElement("div");
        title.classList.add("collapsedPageTitle");
        title.innerHTML = pages[thisElement.getAttribute("pageIndex")].title;
        thisElement.append(title);
        //console.dir("fold click");
        thisElement.classList.remove("unfolded");
        thisElement.classList.add("fold");
        title.classList.add("moveTitleDown");
        thisElement.style.left = thisElement.style.getPropertyValue("--collapsed-left");
        thisElement.style.top = thisElement.style.getPropertyValue("--collapsed-top");
        await delay(3000);
        thisElement.classList.remove("fold");
        title.classList.remove("moveTitleDown");
        if (thisElement.id === "Page1") {
            for (var i = 1; i < pages.length; i++) {
                pages[i].domElement.classList.remove("hidden");
                await fadeIn(pages[i].domElement);
            }
            for (var i = 1; i < pages.length; i++) {
                pages[i].domElement.classList.remove("fadeIn");
            }
            var bodyArr = document.getElementsByTagName("body");
            var body = bodyArr[0];
            body.style.animationDuration = "40s";
        }
        isUnfolded = false;
        isInAnimation = false;
        //location.reload(true);
    }
}
async function onClickEventHandler() {
    if (isInAnimation !== true) {
        if (this.id === "Page1") {
            if (isUnfolded) {
                fold(this);
            } else {
                unfold(this);
            }
        } else if (isPageScriptFinished) {
            if (isUnfolded) {
                fold(this);
            } else {
                unfold(this);
            }
        } else {
            try {
                pageScript();
            } catch (ex) {
                console.dir("Call pageScript, without available Function!");
            }
        }
    }
}
async function fadeIn(element) {
    try {
        element.classList.add("fadeIn");
        await delay(250);
    } catch (ex) {
        console.dir("No Element to fade in");
    }

}
async function fadeOut(element) {
    try {
        element.classList.add("fadeOut");
        await delay(250);
    } catch (ex) {
        console.dir("No Element to fade out");
    }

}
